/*"Gear Indicator": Simple OutGauge client for LFS
 * Author: Vladimir Kadlec
 *         vladimirkadlec@gmail.com
 *         http://www.fi.muni.cz/~xkadlec
 * Updated by:  Nick Aronson 29/05/07
 *              nick (dot) a (dot) aronson (at) gmail (dot) com
 * New feature: 5 LED rev meter outputs added
 */
/*
This file is part of Gear Indicator.

Gear Indicator is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gear Indicator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gear Indicator; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <windows.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <signal.h>

#include "outsim.h"
#include "lpt.h"
#include "log.h"
#include "config.h"

//global variable, unfortunatelly, the signal handler is the reason...
Config *CONFIG;
int *IN_SKT;

void error_exit() {
     fprintf (stderr, "Hit Enter to exit.\n");
     getc (stdin);
     exit (-1);
}

void print_name() {
    printf ("Gear Indicator: A simple OutGauge client for LFS\n");
    printf ("Author: Vladimir Kadlec\n");
    printf ("        vladimirkadlec@gmail.com\n");
    printf ("        http://www.fi.muni.cz/~xkadlec\n");
    printf ("Updated by:  Nick Aronson 29/05/07\n");
    printf ("             nick (dot) a (dot) aronson (at) gmail (dot) com\n");
    printf ("New feature: 5 LED rev meter outputs added\n\n");
}

void signalHandler (int sig) {
   switch (sig){
       case SIGINT:  // == 2
          display_off (CONFIG);
//          closesocket (*IN_SKT);
//          WSACleanup();
          exit (0);
          break;
       default:
          printf("Unknown signal caught=%d\n",sig);
          break;
    };
}

int main (int argc, char *argv[]) {
struct hostent *localhost;
int in_skt;
struct sockaddr_in server_addr;

OutGaugePacket og_packet;

WORD wVersionRequested = MAKEWORD(1,1); // slo verze
WSADATA wsadata;                        // Struktura s info. o knihovn;
static Config conf;

    CONFIG = &conf;
    IN_SKT = &in_skt;

    signal (SIGINT, signalHandler);
    print_name();
    init_config (&conf);
    if (!read_config ("config.txt", &conf)) {
        error ("Read_config\n");
        error_exit();
    }
    print_config (&conf);
	if (!init_lpt (conf.lpt_base)) {
		error ("Can't access LPT port.\n");
		error_exit();
	}
    if ((argc > 1) && (strcasecmp (argv[1], "--blank-and-exit") == 0)) {
        display_off (CONFIG);
        exit (0);
    }
    // Pipravme sokety na prci
    if (WSAStartup(wVersionRequested, &wsadata) != 0) {
        error ("Init socket.\n");
        error_exit();
    }
	localhost = gethostbyname (conf.ip);
	if (localhost == NULL) {
		error ("Can't resolve IP address: %s\n", conf.ip);
        WSACleanup();
		error_exit ();
	}

	in_skt = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (in_skt == INVALID_SOCKET) {
		error ("Create socket.\n");
        WSACleanup();
		error_exit ();
	}
	
	server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons (conf.port);
    memcpy(&(server_addr.sin_addr), localhost->h_addr, localhost->h_length);

	//zadny pripojeni v tehle chvili, pracujem s UDP, je to jen prirazeni
	//adresy

    printf ("Going to bind...\n");
	if (bind (in_skt, (struct sockaddr*)&server_addr,
				sizeof(server_addr)) == SOCKET_ERROR) {
		error ("Bind()\n");
        WSACleanup();
		error_exit ();
    }
	printf ("Listening...\n");
    printf ("Hit Ctrl-C to exit\n");
    if (conf.debug) {
       printf ("Gears sequence:");
       	while (1) {
       		if (recv (in_skt,(void*) &og_packet, sizeof (og_packet), 0)
                                                              == SOCKET_ERROR) {
      			warning ("Problem receiving OutGauge packet.\n");
		    }
		    printf (" %d", og_packet.Gear-1);
            fflush (stdout);
            display_lpt (&conf, &og_packet);
        }
    }
    while (1) {
  		if (recv (in_skt,(void*) &og_packet, sizeof (og_packet), 0)
                                                             == SOCKET_ERROR) {
   			warning ("Problem receiving OutGauge packet.\n");
        }
        display_lpt (&conf, &og_packet);
    }
 //We never get here.
	closesocket (in_skt);
	
	printf ("Bye\n");
    WSACleanup();
    getc (stdin);
	return (1);
}
